local iIndex = Var("GameCommand"):GetIndex();
local sName = Var("GameCommand"):GetName();
local sGameName = GAMESTATE:GetCurrentGame():GetName();

local masterPlayerNum = GAMESTATE:GetMasterPlayerNumber();

local pad = "";
if masterPlayerNum == PLAYER_1 then pad = "p1"
else pad = "p2";
end;

local padGainFocusCmd = cmd(finishtweening;glowshift);
local padLoseFocusCmd = cmd(stopeffect);

-- check the style here so we can see what to add

local t = Def.ActorFrame{ FOV=90; };

if(sName == "Single") then
	t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
		Name="PadSingle"..pad;
		InitCommand=cmd(x,-64;zoom,0.2;rotationx,45;diffuse,PlayerColor(masterPlayerNum););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
elseif(sName == "Versus") then
	t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
		Name="PadVersusP1";
		InitCommand=cmd(x,-64;zoom,0.2;rotationx,45;diffuse,PlayerColor(PLAYER_1););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
	t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
		Name="PadVersusP2";
		InitCommand=cmd(x,64;zoom,0.2;rotationx,45;diffuse,PlayerColor(PLAYER_2););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
elseif(sName == "Double") then
	t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
		Name="PadDouble1";
		InitCommand=cmd(x,-64;zoom,0.2;rotationx,45;diffuse,PlayerColor(masterPlayerNum););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
	t[#t+1] = LoadActor( THEME:GetPathG('','_pads/thepad.lua') )..{
		Name="PadDouble2";
		InitCommand=cmd(x,64;zoom,0.2;rotationx,45;diffuse,PlayerColor(masterPlayerNum););
		GainFocusCommand=padGainFocusCmd;
		LoseFocusCommand=padLoseFocusCmd;
	};
end;

return t;